"""
HB_Solo V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Solo
Description-US: Toggles Solo Mode and frame selected Objects or Polygonselections [SHIFT: Solo Single, CTRL: Toggle Solo Selection]

Usage:
Select one or more Objects. When you run the script the Object and its Childs will be isolated. Also the Camera frames the Object. The same works
for Polygonselections. If you hold CTRL the Script will Toggle Viewport Solo Selection- If you hold SHIFT it will Solo the Single Object without Hierachy.

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=7m56s

Name-DE: HB_Solo
Description-DE: Toggle Solo Mode und zoom auf die selektierten Objekte oder Polygonselektion [SHIFT-CLICK: Solo Single, CTRL-CLICK: Toggle Solo Selection]

ChangeLog:

Jun/11/2015 V1.0
- Release Version：415635208

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d
from c4d import documents, plugins

def main():
    STORE_SOLO=1050272
    bd = doc.GetActiveBaseDraw()
    mysettings_bc=c4d.BaseContainer()
    bc = c4d.BaseContainer()
    obj=doc.GetActiveObject()

    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 :
            if not (c4d.IsCommandChecked(431000059)) and not (c4d.IsCommandChecked(431000060)):# If Solo not on

                Camera=doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]
                CamPos=Camera.GetMg()
                
                mysettings_bc.SetData(1,CamPos)
                c4d.plugins.SetWorldPluginData(STORE_SOLO, mysettings_bc)

            soloMode=1
            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
            soloMode=0
            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==2 :
            
            c4d.CallCommand(431000061) #toggle Viewport Solo Selection
            return
       
    if not (c4d.IsCommandChecked(431000059)) and not (c4d.IsCommandChecked(431000060)):  # Solo not Active?
        
        mysettings_bc.SetData(2, doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA])
        c4d.plugins.SetWorldPluginData(STORE_SOLO, mysettings_bc)

        if (c4d.IsCommandChecked(12187)):# is Poly mode?
  
            if soloMode==1:
                c4d.CallCommand(431000059)# Solo single
 
            if soloMode==0:
                c4d.CallCommand(431000060) # Viewport Solo Hierarchy
            
            Selection=obj.GetPolygonS()
            PolygonCount=Selection.GetCount()
           
            if PolygonCount>0:
                c4d.CallCommand(12479) # Invert
                c4d.CallCommand(12473) # Hide Selected
                c4d.CallCommand(12479) # Invert
                
            doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=bd.GetEditorCamera()
            c4d.CallCommand(13038) # Frame Selected Elements
            
        else:  #  not Poly mode
            
            if soloMode==0:
                c4d.CallCommand(431000059)  # Solo single
                
            if soloMode==1:
                c4d.CallCommand(431000060) # Viewport Solo Hierarchy
                
            doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=bd.GetEditorCamera()
            c4d.CallCommand(12151) # Frame Selected Objects
             
    else: # if solo is active
            mysettings_bc = c4d.plugins.GetWorldPluginData(STORE_SOLO)
            doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=mysettings_bc.GetData(2)  
            Camera=doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]

            OldPos=mysettings_bc.GetData(1)
            Camera.SetMg(OldPos)

            c4d.CallCommand(431000058)#solo off
            Mode=doc.GetMode() #Get Mode
            c4d.CallCommand(12187) # Polygons
            c4d.CallCommand(12475) # Unhide All
            doc.SetMode(Mode) #Set Mode

            c4d.EventAdd()

if __name__=='__main__':
    main()
    c4d.EventAdd()